	function map = makecsmap(csspec)
	%map = makecsmap(csspec)
	%
	%Creates a bitmap of interconnections between the adders in a CS tree
	%Inputs:
	%  cpspec - CS tree specification
	%Outputs:
	%  map - CS tree bitmap
	
	%Copyright (C) 2008 Anton Blad, Oscar Gustafsson.
	%This file is licensed under a modified version of GPL v2, see the file
	%LICENSE for details.
	
	%csspec:
	%  ppin : L-1 x W matrix of input partial products
	%  cin  : L-1 x W matrix of constant term input
	%  bout : 1 x W array of number of output bits
	%  bits : L x W matrix of number of bits at each position
	%  fa   : L-1 x W matrix of number of full adders
	%  ha   : L-1 x W matrix of number of half adders
	%  regs : L-1 x W matrix of number of registers
	
	ppin = csspec.ppin;
	cin = csspec.cin;
	bout = csspec.bout;
	bits = csspec.bits;
	fa = csspec.fa;
	ha = csspec.ha;
	regs = csspec.regs;
	
	L = size(bits, 1);
	W = size(bits, 2);
	
	% Matrix of full adders. Elements:
	% [inlevel inweight inbit1 inbit2 inbit3 outbitsum outbitcarry]
	mapfa = [];
	
	% Matrix of half adders. Elements:
	% [inlevel inweight inbit1 inbit2 outbitsum outbitcarry]
	mapha = [];
	
	% Feed-through connections.
	% [inlevel inweight inbit outbit]
	mapfeed = [];
	
	% [inlevel inweight idx inbit]
	mappp = [];
	
	% [inlevel inweight inbit]
	mapcin = [];
	
	% Connection from obits to bits
	% [inlevel inweight inbit outbit]
	mapconn = [];
	
	% Register from obits to bits
	% [inlevel inweight inbit outbit]
	mapreg = [];
	
	% Assigned output bits from each level
	obits = zeros(L-1, W);
	
	% Matrix of number of assigned bits
	abits = zeros(L, W);
	
	% Assign ppin to bits
	for l = 1:L-1
		for w = W:-1:1
			for b = 0:ppin(l, w)-1
				mappp = [mappp; l w b abits(l, w)];
				abits(l, w) = abits(l, w)+1;
			end
		end
	end
	
	% Assign cin to bits
	for l = 1:L-1
		for w = W:-1:1
			for b = 0:cin(l, w)-1
				mapcin = [mapcin; l w abits(l, w)];
				abits(l, w) = abits(l, w)+1;
			end
		end
	end
	
	% Assign level outputs
	for l = 1:L-1
		for w = W:-1:2
			aidx = bits(l, w)-1;
			for i = 0:fa(l, w)-1
				mapfa = [mapfa; l w aidx aidx-1 aidx-2 obits(l, w) obits(l, w-1)];
				aidx = aidx - 3;
				obits(l, w) = obits(l, w) + 1;
				obits(l, w-1) = obits(l, w-1) + 1;
			end
			for i = 0:ha(l, w)-1
				mapha = [mapha; l w aidx aidx-1 obits(l, w) obits(l, w-1)];
				aidx = aidx - 2;
				obits(l, w) = obits(l, w) + 1;
				obits(l, w-1) = obits(l, w-1) + 1;
			end
			for i = 0:aidx
				mapfeed = [mapfeed; l w aidx obits(l, w)];
				aidx = aidx - 1;
				obits(l, w) = obits(l, w) + 1;
			end
		end
		for w = 1
			aidx = bits(l, w)-1;
			for i = 0:fa(l, w)-1
				mapfa = [mapfa; l w aidx aidx-1 aidx-2 obits(l, w) -1];
				aidx = aidx - 3;
				obits(l, w) = obits(l, w) + 1;
			end
			for i = 0:ha(l, w)-1
				mapha = [mapha; l w aidx aidx-1 obits(l, w) -1];
				aidx = aidx - 2;
				obits(l, w) = obits(l, w) + 1;
			end
			for i = 0:aidx
				mapfeed = [mapfeed; l w aidx obits(l, w)];
				aidx = aidx - 1;
				obits(l, w) = obits(l, w) + 1;
			end
		end
	end
	
	% Assign level connections
	for l = 1:L-1
		for w = W:-1:1
			if obits(l, w) ~= bits(l+1, w)-abits(l+1, w)
				disp(sprintf('Consistency error: obits(%d, %d) = %d != %d', l, w, obits(l, w), bits(l+1, w)-abits(l+1, w)));
			end
			if regs(l, w) ~= 0 & regs(l, w) ~= obits(l, w)
				disp(sprintf('Warning: obits(%d, %d) = %d only has %d registers', l, w, obits(l, w), regs(l, w)));
			end
			bidx = 0;
			for b = 0:regs(l, w)-1
				mapreg = [mapreg; l w bidx abits(l+1, w)];
				bidx = bidx + 1;
				abits(l+1, w) = abits(l+1, w) + 1;
			end
			for b = 1:obits(l, w)-bidx
				mapconn = [mapconn; l w bidx abits(l+1, w)];
				bidx = bidx + 1;
				abits(l+1, w) = abits(l+1, w) + 1;
			end
		end
	end
	
	map.L = L;
	map.W = W;
	map.pp = mappp;
	map.cin = mapcin;
	map.fa = mapfa;
	map.ha = mapha;
	map.feed = mapfeed;
	map.conn = mapconn;
	map.reg = mapreg;
	
